/**   This file is part of:
  *   sauditor - sample auditor  
  *   Copyright (C) 2009  James Shuttleworth
  *
  *   Contact: james@dis-dot-dat.net
  *
  *   This program is free software; you can redistribute it and/or modify
  *   it under the terms of the GNU General Public License as published by
  *   the Free Software Foundation; either version 2 of the License, or
  *   (at your option) any later version.
  *
  *   This program is distributed in the hope that it will be useful,
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *   GNU General Public License for more details.
  *
  *   You should have received a copy of the GNU General Public License
  *   along with this program; if not, write to the Free Software
  *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  *
  */

#include "dirFollow.h"
#include <iostream>
#include <stdlib.h>
#include <string.h>
using namespace std;
dirFollow::dirFollow(){
  withDots=false;
}

string dirFollow::getPath(){
  return string(path);
}

void dirFollow::setPath(string newPath){
  path=string(newPath.c_str());

}

int dirFollow::getFiles(string** &fls){
  return getEntries(DT_REG,fls);
}

int dirFollow::getDirs(string** &fls){
  return getEntries(DT_DIR,fls);
}


int dirFollow::getEntries(int type, string** &out){
    struct direct **files;
    int count = scandir(path.c_str(), &files, &file_select, alphasort);

    int ecount=0;

    
    //count the number of files
    for(int i=0;i<count;i++){

	//Tidy this up!  Repeated below.
	//Check if files starting with "." should be included.  Special cases for "." and "..".
      if(files[i]->d_type==type ){

	if(withDots || (strlen(files[i]->d_name)>1 && (files[i]->d_name)[0]!='.') ||(strlen(files[i]->d_name)==1 || (strlen(files[i]->d_name)==2 && (files[i]->d_name)[1]=='.')))
	  ecount++;		
	 
	
      }
    }

    if(ecount==0)
      return 0;
    out= (string**)malloc(ecount*sizeof(string*));//new string*[filecount];
    
    int cfile=0;
    for(int i=0;i<count;i++){
      if(files[i]->d_type==type ){
	//Tidy this up!  Repeated above.
	//Check if files starting with "." should be included.  Special cases for "." and "..".
	if(withDots || (strlen(files[i]->d_name)>1 && (files[i]->d_name)[0]!='.') ||(strlen(files[i]->d_name)==1 || (strlen(files[i]->d_name)==2 && (files[i]->d_name)[1]=='.'))){
	  
	  out[cfile]=new string(path.c_str());
	  out[cfile]->append(files[i]->d_name);
	  cfile++;
	}
      }
    }
    // for(int i=0;i<cfile;i++)
    //  cout << out[i]->c_str()<<endl;
    
    
    
    free(files);
    return ecount;
}









int dirFollow::file_select(const struct dirent* entry){
  /*if ((strcmp(entry->d_name, ".") == 0) || (strcmp(entry->d_name, "..") == 0))
    return 0;
    else*/
    return 1;
}

