/**   This file is part of:
  *   sauditor - sample auditor  
  *   Copyright (C) 2009  James Shuttleworth
  *
  *   Contact: james@dis-dot-dat.net
  *
  *   This program is free software; you can redistribute it and/or modify
  *   it under the terms of the GNU General Public License as published by
  *   the Free Software Foundation; either version 2 of the License, or
  *   (at your option) any later version.
  *
  *   This program is distributed in the hope that it will be useful,
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *   GNU General Public License for more details.
  *
  *   You should have received a copy of the GNU General Public License
  *   along with this program; if not, write to the Free Software
  *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  *
  */

/** http://www.fftw.org/fftw3_doc/Upgrading-from-FFTW-version-2.html**/

#include <iostream>
#include <fftw3.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "fftpart.h"



long len;
double *in, *out;
long start,end;
using namespace std;
fftw_plan plan;
void ftocomplex(double* d, double* comp, int len){
  for(int i=0;i<len;i++){
    comp[i]=d[i];
  }
}
float maxv=0;

void fftpart_setup(long inputsize, long startp, long endp){
  start=startp;
  end=endp;
  len=inputsize;

  fftpart_close();
  in = (double*)fftw_malloc(sizeof(double)*len); //Rob uncommented this.  In fftw2 you don't have to use the input array, just one it's size.
  out = (double*)fftw_malloc(2*sizeof(double)*len);//Output is 2x as big in HC format.
  plan=fftw_plan_r2r_1d(len, in, out, FFTW_R2HC, FFTW_ESTIMATE );
  if(!plan)
	  cerr << "Plan could not be created.\n"; //Rob added this for fftw3.
  // This should probably be changed from void to return a 1 for an error
  // so that the caller can fail gracefully.
}

void fftpart_setup(long inputsize){
  fftpart_setup( inputsize,0,inputsize);
}


void fftpart_close(){
  if(in)
    fftw_free(in); 
  if(out)
    fftw_free(out);    
  if(plan)
    fftw_destroy_plan(plan);
    //cerr << "Plan just destroyed!\n";
}


void fftpart_grab(int bins, double* data, double* dout){
  //cerr<<"FFT grabbing "<<bins<<" bins, len="<<len<<endl;
  static int noplancount = 0;
  for(int i=0; i<len; i++) in[i]=data[i]; //Necessary because fftw3 must use in and out.
  if(plan)
	fftw_execute(plan);
  else if ( noplancount++ < 4 )
	cerr << "No plan! \n";
 

/* Rob's comments below:
 * Why do we even do this?  We should just set the length of the FFT smaller.
 * Perhaps that would draw to the screen too often.
 *
 * This also doesn't seem to take into account the half complex format of the output data.
 * The imaginary part is in the second half of the array.  It appears
 * to be ignored, so that the spectrum is only due to the odd part of
 * the input signal.
 * See http://www.fftw.org/fftw3_doc/The-Halfcomplex_002dformat-DFT.html
 *
 */
 
 int binsize=(end-start)/(bins);
 
  //cerr<<"FFT sifting\n";
  for(int i=start;i<end;i+=binsize){
    float val=0;
    for(int j=0;j<binsize;j++)
      val+=log(abs(int(out[i])));
    if(val>maxv)
      maxv=val;
  }
  //cerr<<"FFT scaling\n";
  for(int i=start;i<end;i+=binsize){
    float val=0;
    for(int j=0;j<binsize;j++)
      val+=abs(int(out[i]));
    if(maxv>0)
      val=val/maxv;
    else
      val=0;
    if(i/binsize<bins)
      dout[i/binsize]=val;
  }
  //cerr<<"FFT done grab\n";
  //cerr<<maxv<<endl;
  
  // This routine should also probably be made to report failure.
}


