/**   This file is part of:
  *   sauditor - sample auditor  
  *   Copyright (C) 2009  James Shuttleworth
  *
  *   Contact: james@dis-dot-dat.net
  *
  *   This program is free software; you can redistribute it and/or modify
  *   it under the terms of the GNU General Public License as published by
  *   the Free Software Foundation; either version 2 of the License, or
  *   (at your option) any later version.
  *
  *   This program is distributed in the hope that it will be useful,
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *   GNU General Public License for more details.
  *
  *   You should have received a copy of the GNU General Public License
  *   along with this program; if not, write to the Free Software
  *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  *
  */

#include <jack/jack.h>

#ifndef _JACKPART_H
#define _JACKPART_H

typedef jack_default_audio_sample_t sample_t;

void jackpart_close();

int jackpart_open();

void jackpart_setSound(const sample_t* snd, long nsamples);

void jackpart_start();
    
void jackpart_stop();

int jackpart_samplerate();

bool jackpart_playing();

void jackpart_setproc(void(*callback)(long,double*));

#endif /* _JACKPART_H */
