/***************************************************************************
 * jack-skeleton
 * 
 * This program is a skeleton program to use to get data from a Jack 
 * source to process.
 *
 * Written:
 *  May 2013
 *  by Rob Frohne
 *  e-mail: Rob "dot" Frohne "at sign" wallawalla "dot" edu
 * 
 ****************************************************************************/

/* To build this program, you must have jack audio connection kit installed.
 * At the command prompt:
 * $ gcc jack-skeleton.c -ljack -o jack-skeleton
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <jack/jack.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <getopt.h>
#include <string.h>

 

/* global jack variables. */
jack_client_t *test_client;
jack_port_t *audio_input_port_left, *audio_input_port_right;

/* To use this command, you need to $ jack-skeleton
 * assuming those are the options you want.
 * Options are:
 * -? for help
 * -v or --verbose for verbose response.
 */
/* Flag set by ‘--verbose’. */
static int verbose_flag;
// Specify options and their syntax
static struct option long_options[] =
{
	/* These options set a flag. */
	{"verbose", no_argument,       &verbose_flag, 1},
	{"brief",   no_argument,       &verbose_flag, 0},
	/* These options don't set a flag.
	We distinguish them by their indices. */
	{"help",     no_argument,      0, '?'},
	{0, 0, 0, 0}
};

/* Close things opened. */
void cleanup(void) {
	if(test_client != NULL) {
		jack_deactivate(test_client);	
		jack_client_close(test_client);
	}
}

/* This is the function that is called when and if jackd shuts down. */
void jack_shutdown (void *arg)
{
	fprintf (stderr, "JACK shutdown\n");
	cleanup();
	abort();
}
 
/* This is the callback process that gets data from jack.*/	
int process(jack_nframes_t number_of_frames, void *arg)
{  //Use static variables if you want to save things between calls to
	// this process.
	jack_default_audio_sample_t *sample_buffer_left = 
	(jack_default_audio_sample_t *) jack_port_get_buffer(audio_input_port_left, number_of_frames);
 
	jack_default_audio_sample_t *sample_buffer_right = 
	(jack_default_audio_sample_t *) jack_port_get_buffer(audio_input_port_right, number_of_frames);
      
	jack_nframes_t i;
	//This is where you get your data in the format that the program using /dev/dsp needs it.
	for(i = 0; i < number_of_frames; i++){
		// This is where you process your data.  
	}
	return 0;
}


int main (int argc, char *argv[]){
	
	int error;
	
	char * fifo_name = PIPE_NAME;  
	
	
	// Iterate over options and handle each one as appropriate
	int c;
	// The function getopt_long stores the option index here.
	int option_index = 0;

	while ( (c = getopt_long ( argc, argv, "v?f:",
	                          long_options, &option_index )) != -1 )
	{
		switch ( c )
		{
			case 0:
				// If this option set a flag, do nothing else now.
				if ( long_options[option_index].flag != 0 )
					break;

			case 'v':
				verbose_flag = 1;
				break;

			case '?':

			default :
				printf(
				"Options are: \n"
				"-v or --verbose for verbose output\n"
				"Typing EOF (ctrl-D) (ctrl-capitol D, to be exact) will end the program.\n");
				exit ( 0 );
		}
	}
	//Create a new jack client, then make sure everything went ok.
	test_client = jack_client_open("Test Client",(jack_options_t)(!JackServerName),NULL);
	if (test_client == 0) {
    	fprintf(stderr,"Cannot connect to the jackd as a client.\n");
    	cleanup();
    	return 1;
  	}
  	  	/* Set up Jack */
  	//Set up the jack shutdown routine in case we want to do something special on shutdown of jack.
  	jack_on_shutdown (test_client, jack_shutdown, 0);

	//Create and register new audio input ports.
	audio_input_port_left = jack_port_register(test_client, "Audio FIFO Port_left", 
						JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput, 0);
	if (audio_input_port_left == NULL) {
		fprintf(stderr, "Error: jack_port_register returned NULL for left channel.\n");
		cleanup();
		return 1;
	}
		
	audio_input_port_right = jack_port_register(test_client, "Audio FIFO Port_right", 
						JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput, 0);
	if (audio_input_port_right == NULL) {
		fprintf(stderr, "Error: jack_port_register returned NULL for right channel.\n");
		cleanup();
		return 1;
	}
	
	//Tell the jackd server what function call when it wants more audio data.
	if((error = jack_set_process_callback(test_client, process, &pipe_handle)) != 0) { 
		fprintf(stderr, "Jack could not set the callback, (error %i).\n", error);
		cleanup();
		return 1;
	}
	
	//Tell jack it's ok to start asking us for audio data.
	if((error = jack_activate(test_client)) != 0) {
		fprintf(stderr, "Jack could not activate the client (error %i).\n", error);
		cleanup();
		return 1;
	}
	else if(verbose_flag) fprintf(stderr,"Activated client.\n");
	
	//Connect the ports.	
	if (jack_connect (test_client,"system:capture_1", jack_port_name (audio_input_port_left))) {
        fprintf (stderr, "cannot connect port: system:capture_1\n");
    }
    else if(verbose_flag) fprintf(stderr, "Connected to port: system:capture_1\n");
	if (jack_connect (test_client,"system:capture_2", jack_port_name (audio_input_port_right))) {
        fprintf (stderr, "cannot connect port: system:capture_2\n");
    }
    else if(verbose_flag) fprintf(stderr, "Connected to port: system:capture_2\n");
	
	while(getchar() != EOF){
		//Quit on ctrl-D.
	}
	
	/* Close things opened. */
	cleanup();	

	return 0;
}
 
