//============================================================
// LED Blinker
//
// Author: Rob Frohne
// Last Modified: February 2014
// Description:   Starting Code for Intro to CAD prototype using 5 LED's
//		  
//============================================================

int pins[] = {9,8,7,10,11};	// An array of pin numbers in the order of
                                // your LEDs.
int rows= 5;		        // Total number of LED's in your row.

//Data corresponding to the each character or shape to be displayed...

byte heart[]={B01000,B01100,B11110,B01111,B11110,B01100,B01000,B00000};
byte box[]={B11111,B11111,B11111,B11111,B11111,B11111,B11111,B11111};
byte roll[]={B00001,B00011,B00111,B01111,B11111,B11110,B11100,B11000,B10000,B0000};
byte backforth[]={B00010,B00100,B01000,B10000,B01000,B00100,B00010,B00001};
byte blinking[]={B11111,B00000};


// customizable parameters
int timer1 = 100;//2.2;			 // time between columns
int timer2 = 100;//20		                // time between frames
//int frame_len = 8;		                // frame length

void setup()
{
  int i;
  for (i = 0; i < rows; i++) {
    pinMode(pins[i], OUTPUT);	// set each pin as an output
  }
  Serial.begin(9600); // Useful for debugging (Use Serial.print();)
}

void loop()
{
  int b=0;
  
  while(1)
  {
    delay(timer2);
    show(blinking,sizeof(blinking));
    delay(timer2);
    show(backforth,sizeof(backforth));
  }
}

void show( byte* image, int frame_len )
{
  int b,c;
  
  // go through all data for all columns in each frame.
    for (b = 0; b < frame_len; b++)
    {
      for (c = 0; c < rows; c++)
      {
        digitalWrite(pins[c], bitRead(image[b], c));
      }
      delay(timer1);
    }
    for (c = 0; c < rows; c++)
    {
      digitalWrite(pins[c], LOW);
    }
}

