function [spd_rps,spd_rpm] = motor_speed(t,e)
% Both edges of two different pulses from the encoder are counted, and the 
% encoders pulse 48 times per revolution, giving 48*4=192 counts per
% revolution.
spd_Hz = -diff(e)/(48*4)./diff(t);
%NOTE: this is a crude first order numerical differentiation, a better
%algorithm could also be used. This algorithm returns one less data point.
spd_rps = spd_Hz*2*pi;
spd_rpm = spd_Hz*60;
end